/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import php.java.bridge.JavaBridge;
import php.java.bridge.parser.HexOutputBuffer;

class Base64EncodingOutputBuffer
extends HexOutputBuffer {
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final char[] lookUpBase64Alphabet;

    Base64EncodingOutputBuffer(JavaBridge bridge) {
        super(bridge);
    }

    void appendBase64(byte[] binaryData) {
        byte val2;
        byte val1;
        if (binaryData == null) {
            return;
        }
        int lengthDataBits = binaryData.length * 8;
        if (lengthDataBits == 0) {
            return;
        }
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        int numberQuartet = fewerThan24bits != 0 ? numberTriplets + 1 : numberTriplets;
        int numberLines = (numberQuartet - 1) / 19 + 1;
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int dataIndex = 0;
        int i = 0;
        for (int line = 0; line < numberLines - 1; ++line) {
            for (int quartet = 0; quartet < 19; ++quartet) {
                b1 = binaryData[dataIndex++];
                b2 = binaryData[dataIndex++];
                b3 = binaryData[dataIndex++];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                byte val12 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
                byte val22 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
                byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
                this.write(lookUpBase64Alphabet[val12]);
                this.write(lookUpBase64Alphabet[val22 | k << 4]);
                this.write(lookUpBase64Alphabet[l << 2 | val3]);
                this.write(lookUpBase64Alphabet[b3 & 0x3F]);
                ++i;
            }
            this.write(10);
        }
        while (i < numberTriplets) {
            b1 = binaryData[dataIndex++];
            b2 = binaryData[dataIndex++];
            b3 = binaryData[dataIndex++];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            this.write(lookUpBase64Alphabet[val1]);
            this.write(lookUpBase64Alphabet[val2 | k << 4]);
            this.write(lookUpBase64Alphabet[l << 2 | val3]);
            this.write(lookUpBase64Alphabet[b3 & 0x3F]);
            ++i;
        }
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            this.write(lookUpBase64Alphabet[val1]);
            this.write(lookUpBase64Alphabet[k << 4]);
            this.write(61);
            this.write(61);
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            this.write(lookUpBase64Alphabet[val1]);
            this.write(lookUpBase64Alphabet[val2 | k << 4]);
            this.write(lookUpBase64Alphabet[l << 2]);
            this.write(61);
        }
        this.write(10);
    }

    static {
        int i;
        lookUpBase64Alphabet = new char[64];
        for (i = 0; i <= 25; ++i) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            Base64EncodingOutputBuffer.lookUpBase64Alphabet[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        Base64EncodingOutputBuffer.lookUpBase64Alphabet[62] = 43;
        Base64EncodingOutputBuffer.lookUpBase64Alphabet[63] = 47;
    }
}

