/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.util;

import java.security.Permission;
import php.java.bridge.util.AppThreadPool;
import php.java.bridge.util.Thread;

public class JavaBridgeSecurityManager
extends SecurityManager {
    protected static final Permission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    protected static final Permission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");

    @Override
    public void checkAccess(ThreadGroup g) {
        if (g == null) {
            throw new NullPointerException("thread group can't be null");
        }
        if (g instanceof AppThreadPool.Group && ((AppThreadPool.Group)g).isLocked) {
            this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        } else if (g instanceof AppThreadPool.AppGroup) {
            this.checkPermission(MODIFY_THREADGROUP_PERMISSION);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        try {
            AppThreadPool.Delegate delegate = (AppThreadPool.Delegate)Thread.currentThread();
            return delegate.getAppGroup();
        }
        catch (ClassCastException e) {
            return super.getThreadGroup();
        }
    }

    @Override
    public void checkExit(int status) {
        throw new SecurityException("exitVM disabled by JavaBridgeSecurityManager.java");
    }
}

