/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import php.java.bridge.util.Logger;
import php.java.fastcgi.Connection;
import php.java.fastcgi.Continuation;
import php.java.fastcgi.FCGIConnectionPool;
import php.java.fastcgi.FCGIHeaderParser;
import php.java.fastcgi.FCGIInputStream;
import php.java.fastcgi.FCGIOutputStream;
import php.java.fastcgi.FCGIUtil;
import php.java.fastcgi.PhpException;

public class FCGIProxy
extends Continuation {
    protected Map env;
    protected OutputStream out;
    private OutputStream err;
    protected FCGIHeaderParser headerParser;
    private FCGIConnectionPool fcgiConnectionPool;
    Connection connection = null;

    public FCGIProxy(Map env, OutputStream out, OutputStream err, FCGIHeaderParser headerParser, FCGIConnectionPool fcgiConnectionPool) {
        this.env = env;
        if (env == null) {
            throw new NullPointerException("env");
        }
        if (env.get("SCRIPT_FILENAME") == null) {
            throw new IllegalArgumentException("SCRIPT_FILENAME missing in env");
        }
        this.out = out;
        this.err = err;
        this.headerParser = headerParser;
        this.fcgiConnectionPool = fcgiConnectionPool;
        if (fcgiConnectionPool == null) {
            throw new NullPointerException("fcgiConnectionPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws IOException, PhpException {
        byte[] buf = new byte[65535];
        FCGIInputStream natIn = null;
        FCGIOutputStream natOut = null;
        try {
            this.connection = this.fcgiConnectionPool.openConnection();
            natIn = (FCGIInputStream)this.connection.getInputStream();
            natOut = (FCGIOutputStream)this.connection.getOutputStream();
            natOut.setId(this.connection.getId());
            natOut.writeBegin(this.connection.isLast());
            natOut.writeParams(this.env);
            natOut.write(4, FCGIUtil.FCGI_EMPTY_RECORD);
            natOut.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
            natOut.close();
            natOut = null;
            this.headerParser.parseBody(buf, natIn, this.out, this.err);
            natIn.close();
            natIn = null;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            Logger.printStackTrace(t);
        }
        finally {
            if (natIn != null) {
                this.connection.setIsClosed();
            }
            this.fcgiConnectionPool.closeConnection(this.connection);
            this.connection = null;
        }
    }

    public boolean canStartFCGI() {
        return true;
    }

    public void log(String msg) {
        Logger.logMessage(msg);
    }
}

