/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import php.java.bridge.util.Logger;
import php.java.script.CompiledPhpScript;
import php.java.script.PhpScriptEngine;
import php.java.script.PhpScriptEngineFactory;
import php.java.script.ResultProxy;

public class CompiledPhpScriptEngine
extends PhpScriptEngine
implements Compilable {
    private boolean compiled;
    private boolean compile;
    private static final File emptyScriptFile;

    public CompiledPhpScriptEngine(Bindings n) {
        this();
        this.setBindings(n, 100);
    }

    public CompiledPhpScriptEngine() {
        this(new PhpScriptEngineFactory());
    }

    public CompiledPhpScriptEngine(PhpScriptEngineFactory factory) {
        this.factory = factory;
        this.getContext();
        this.setStandardBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalCompiled(ScriptContext context) throws ScriptException {
        ScriptContext current = this.getContext();
        if (current != context) {
            try {
                this.setContext(context);
                Object object = this.evalCompiledPhp();
                return object;
            }
            finally {
                this.setContext(current);
            }
        }
        return this.evalCompiledPhp();
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            this.compilePhp(reader);
            return new CompiledPhpScript(this);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private Object evalCompiledPhp() throws ScriptException {
        if (this.continuation != null) {
            this.releaseCompiled();
        }
        this.setNewContextFactory(this.env);
        this.env.put("SCRIPT_FILENAME", this.scriptFile.getAbsolutePath());
        try {
            this.script = this.doEvalPhp(null);
            if (this.script != null) {
                this.scriptClosure = this.script;
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
        finally {
            this.resultProxy = new ResultProxy(this).withResult(this.ctx.getContext().getExitCode());
            this.handleRelease();
        }
        return this.resultProxy;
    }

    public boolean isCompiled() {
        return this.compiled && this.continuation != null;
    }

    protected void compilePhp(Reader reader) throws IOException, ScriptException {
        this.compile = true;
        this.evalPhp(reader);
        this.compiled = true;
    }

    @Override
    protected void compileScript(Reader reader) throws ScriptException {
        super.compileScript(reader);
        if (this.compile) {
            this.env.put("SCRIPT_FILENAME", emptyScriptFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledScript compile(String script) throws ScriptException {
        StringReader reader = new StringReader(script);
        try {
            CompiledScript compiledScript = this.compile(reader);
            return compiledScript;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseCompiled() {
        Set set = engines;
        synchronized (set) {
            this.releaseInternal(false);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.compiled) {
            this.release();
        } else {
            this.releaseCompiled();
        }
    }

    static {
        try {
            emptyScriptFile = File.createTempFile("pjbempty", ".php");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        emptyScriptFile.deleteOnExit();
    }
}

